/*
 * Decompiled with CFR 0.152.
 */
package com.ladybug.vilain;

import cam.ladybug.script.EnemiesManager;
import cam.ladybug.script.FireScript;
import cam.ladybug.script.PlayerScript;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.esotericsoftware.tablelayout.Cell;
import com.ladybug.engine.components.BoxCollider;
import com.ladybug.engine.game.Game2D;
import com.ladybug.engine.game.Global;
import com.ladybug.engine.game.LayerManager;
import com.ladybug.engine.game.Scene;
import com.ladybug.engine.gameobject.GameObject;
import com.ladybug.vilain.GlobalVilain;
import java.util.ArrayList;

public class LadybugVilain
extends Game2D {
    private OrthographicCamera camera;
    private SpriteBatch batch;
    private Texture texture;
    private Sprite sprite;
    protected Stage m_stage;
    protected Table m_table;
    protected Label m_score;
    protected Cell m_scoreCell;

    public LadybugVilain() {
        WIDTH = 340;
        HEIGHT = 220;
        Scene scene = new Scene();
        Scene.WIDTH = 340;
        Scene.HEIGHT = 220;
        this.addScene(scene);
        GameObject bg = new GameObject(0.0f, 0.0f, "data/bg.png", WIDTH, HEIGHT, "BG");
        scene.addObject(bg);
        GameObject ground = new GameObject(0.0f, 20.0f, "Ground");
        ground.addComponent(new BoxCollider(400.0f, 48.0f));
        ground.collider.LAYER = LayerManager.GROUND;
        scene.addObject(ground);
        GameObject go = new GameObject(240.0f, 100.0f, "data/bowser.png", 42, 42, "Player");
        PlayerScript ps = new PlayerScript();
        ArrayList<FireScript> bullets = new ArrayList<FireScript>();
        int i = 0;
        while (i < 13) {
            GameObject fire = new GameObject(0.0f, 0.0f, "data/fire.png", 32, 16, "FireBullet");
            FireScript fs = new FireScript();
            fire.addComponent(fs);
            fire.addComponent(new BoxCollider(16.0f, 8.0f));
            bullets.add(fs);
            scene.addObject(fire);
            ++i;
        }
        ps.setBullets(bullets);
        go.addComponent(ps);
        scene.addObject(go);
        GameObject manager = new GameObject();
        manager.addComponent(new EnemiesManager(scene));
        scene.addObject(manager);
    }

    @Override
    public void create() {
        super.create();
        Scene currentScene = Global.currentScene;
        this.m_stage = new Stage(WIDTH, HEIGHT, true, Scene.batch);
        Gdx.input.setInputProcessor(this.m_stage);
        this.m_table = new Table();
        this.m_table.setFillParent(true);
        this.m_table.setPosition(0.0f, 0.0f);
        this.m_table.pack();
        this.m_stage.addActor(this.m_table);
        Label.LabelStyle style = new Label.LabelStyle(new BitmapFont(), Color.WHITE);
        this.m_score = new Label((CharSequence)"Score", style);
        this.m_scoreCell = this.m_table.add(this.m_score);
        this.m_scoreCell.expandX();
        this.m_scoreCell.expandY();
        this.m_scoreCell.right();
        this.m_scoreCell.top();
        currentScene.addStage(this.m_stage);
    }

    @Override
    public void render() {
        this.update();
        super.render();
        Table.drawDebug(this.m_stage);
    }

    public void update() {
        int score = (int)GlobalVilain.SCORE;
        this.m_score.setText("Score : " + String.valueOf(score));
    }
}

