/*
 * Decompiled with CFR 0.152.
 */
package com.ladybug.engine.gameobject;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.ladybug.engine.components.Component;
import com.ladybug.engine.game.Global;

public class Renderer
extends Component {
    public String m_textureName;
    public int m_textureHeight;
    public int m_textureWidth;
    int m_textureOriginX;
    int m_textureOriginY;

    public Renderer() {
        this.m_type = Component.TYPE.RENDERER;
    }

    public Renderer(String name) {
        this.m_type = Component.TYPE.RENDERER;
        this.m_textureName = name;
    }

    public Renderer(String name, int w, int h) {
        this.m_type = Component.TYPE.RENDERER;
        this.m_textureName = name;
        this.m_textureWidth = w;
        this.m_textureHeight = h;
    }

    public void loadAssets() {
        if (this.m_textureName == null || this.m_textureName == "") {
            return;
        }
        if (!Global.assets.containsAsset(this.m_textureName)) {
            Global.assets.load(this.m_textureName, Texture.class);
        }
    }

    protected void loadSprite() {
        if (this.m_textureName == null || this.m_textureName == "" || !Global.assets.isLoaded(this.m_textureName, Texture.class)) {
            return;
        }
        Texture texture = Global.assets.get(this.m_textureName, Texture.class);
        if (this.m_textureHeight == 0 || this.m_textureWidth == 0) {
            this.m_textureHeight = texture.getHeight();
            this.m_textureWidth = texture.getWidth();
        }
        TextureRegion region = new TextureRegion(texture, this.m_textureOriginX, this.m_textureOriginY, this.m_textureWidth, this.m_textureHeight);
        this.m_object.setRegion(region);
        this.m_object.setSize(this.m_textureWidth, this.m_textureHeight);
    }

    public void setFrame(int i, int j) {
        int w = this.getObject().getTexture().getWidth();
        int h = this.getObject().getTexture().getHeight();
        if (i * this.m_textureWidth > w - this.m_textureWidth) {
            return;
        }
        if (j * this.m_textureHeight > h - this.m_textureHeight) {
            return;
        }
        this.getObject().setRegion(i * this.m_textureWidth, j * this.m_textureHeight, this.m_textureWidth, this.m_textureHeight);
    }
}

