/*
 * Decompiled with CFR 0.152.
 */
package com.ladybug.engine.game;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.ladybug.engine.game.CollisionManager;
import com.ladybug.engine.game.Global;
import com.ladybug.engine.gameobject.GameObject;
import java.util.ArrayList;

public class Scene {
    public static int WIDTH = 640;
    public static int HEIGHT = 360;
    ArrayList<GameObject> m_objects = new ArrayList();
    ArrayList<Stage> m_stages = new ArrayList();
    OrthographicCamera m_mainCamera;
    public static SpriteBatch batch;
    boolean loading = true;
    boolean reseting = false;
    CollisionManager m_collisionManager;

    public void init() {
        int i = 0;
        while (i < this.m_objects.size()) {
            this.m_objects.get(i).coreAwake();
            ++i;
        }
        i = 0;
        while (i < this.m_objects.size()) {
            this.m_objects.get(i).coreStart();
            ++i;
        }
        this.initCollisionManager();
    }

    void initCollisionManager() {
        this.m_collisionManager = new CollisionManager();
        ArrayList<GameObject> objects = this.getObjects();
        int i = 0;
        while (i < objects.size()) {
            ArrayList<GameObject> objs = objects.get(i).getAllObjects();
            int j = 0;
            while (j < objs.size()) {
                this.m_collisionManager.addCollider(objs.get((int)j).collider);
                ++j;
            }
            ++i;
        }
    }

    public void load() {
        batch = new SpriteBatch();
        this.m_mainCamera = new OrthographicCamera();
        this.m_mainCamera.setToOrtho(false, WIDTH, HEIGHT);
        Global.mainCamera = this.m_mainCamera;
        int i = 0;
        while (i < this.m_objects.size()) {
            this.m_objects.get(i).loadAssets();
            ++i;
        }
    }

    public void bindAssets() {
        int i = 0;
        while (i < this.m_objects.size()) {
            this.m_objects.get(i).bindAssets();
            ++i;
        }
    }

    public void addCamera(OrthographicCamera camera) {
        this.m_mainCamera = camera;
    }

    public void updateObjects() {
        int i = 0;
        while (i < this.m_objects.size()) {
            this.m_objects.get(i).corePreUpdate();
            ++i;
        }
        i = 0;
        while (i < this.m_objects.size()) {
            this.m_objects.get(i).coreUpdate();
            ++i;
        }
        i = 0;
        while (i < this.m_objects.size()) {
            this.m_objects.get(i).corePostUpdate();
            ++i;
        }
    }

    public void drawObjects(SpriteBatch batch) {
        int i = 0;
        while (i < this.m_objects.size()) {
            this.m_objects.get(i).draw(batch);
            ++i;
        }
    }

    public void addObject(GameObject go) {
        this.m_objects.add(go);
    }

    public void addStage(Stage _stage) {
        this.m_stages.add(_stage);
    }

    public void dispose() {
        batch.dispose();
        int i = 0;
        while (i < this.m_objects.size()) {
            this.m_objects.get(i).dispose();
            ++i;
        }
    }

    public void render() {
        if (this.loading) {
            if (Global.assets.update()) {
                this.bindAssets();
                this.init();
                this.loading = false;
            }
            return;
        }
        if (Gdx.input.isKeyPressed(131)) {
            this.reset();
            this.reseting = true;
        } else {
            this.reseting = false;
        }
        Gdx.gl.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.updateObjects();
        this.m_collisionManager.update();
        this.m_mainCamera.update();
        batch.setProjectionMatrix(this.m_mainCamera.combined);
        batch.begin();
        this.drawObjects(batch);
        batch.end();
        int i = 0;
        while (i < this.m_stages.size()) {
            this.m_stages.get(i).draw();
            ++i;
        }
    }

    public void reset() {
        int i = 0;
        while (i < this.m_objects.size()) {
            this.m_objects.get(i).reset();
            ++i;
        }
        i = 0;
        while (i < this.m_stages.size()) {
            this.m_stages.get(i).clear();
            ++i;
        }
    }

    public ArrayList<GameObject> getObjects() {
        return this.m_objects;
    }

    public ArrayList<Stage> getStages() {
        return this.m_stages;
    }
}

