/*
 * Decompiled with CFR 0.152.
 */
package com.ladybug.engine.game;

import com.ladybug.engine.components.Collider;
import com.ladybug.engine.game.LayerManager;
import java.util.ArrayList;

public class CollisionManager {
    ArrayList<Collider> m_colliders = new ArrayList();

    public void addCollider(Collider collider) {
        this.m_colliders.add(collider);
    }

    public void update() {
        int i = 0;
        while (i < this.m_colliders.size()) {
            if (i + 1 > this.m_colliders.size()) break;
            int j = i + 1;
            while (j < this.m_colliders.size()) {
                Collider coll1 = this.m_colliders.get(i);
                Collider coll2 = this.m_colliders.get(j);
                if (coll1 != null && coll1.enabled && coll2 != null && coll2.enabled && LayerManager.collide(coll1.LAYER, coll2.LAYER)) {
                    this.checkCollisions(coll1, coll2);
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.m_colliders.size()) {
            if (this.m_colliders.get(i) != null) {
                this.m_colliders.get(i).processCollisions();
            }
            ++i;
        }
    }

    public void checkCollisions(Collider coll1, Collider coll2) {
        ArrayList<Collider> colliders = coll1.collide(coll2);
        if (colliders != null && colliders.size() > 0) {
            int c = 0;
            while (c < colliders.size()) {
                coll1.addCollision(colliders.get(c));
                colliders.get(c).addCollision(coll1);
                ++c;
            }
        }
    }
}

