/*
 * Decompiled with CFR 0.152.
 */
package com.ladybug.engine.components;

import com.badlogic.gdx.math.Vector2;
import com.ladybug.engine.components.Component;

public class Rigidbody
extends Component {
    protected float m_acceleration;
    protected Vector2 m_velocity;
    public boolean m_onGround = false;
    public boolean gravity = true;

    public Rigidbody() {
        this.m_type = Component.TYPE.RIGIDBODY;
        this.m_velocity = new Vector2();
    }

    @Override
    public void update() {
        if (this.gravity) {
            this.applyGravity();
        }
        this.m_object.translate(this.m_velocity.x, this.m_velocity.y);
    }

    public float getAcceleration() {
        return this.m_acceleration;
    }

    public void setAcceleration(float acc) {
        this.m_acceleration = acc;
    }

    public void applyGravity() {
        if (!this.m_onGround) {
            this.m_acceleration = (float)((double)this.m_acceleration + 0.1);
            this.m_object.translateY(-this.m_acceleration);
        }
    }

    public Vector2 getVelocity() {
        return this.m_velocity;
    }

    public void setVelocity(Vector2 v) {
        this.m_velocity = v;
    }

    public void setVelocity(float x, float y) {
        this.m_velocity.x = x;
        this.m_velocity.y = y;
    }

    public void addVelocity(float x, float y) {
        this.m_velocity.x += x;
        this.m_velocity.y += y;
    }

    @Override
    public void reset() {
        this.m_onGround = false;
        this.m_velocity = new Vector2();
        this.m_acceleration = 0.0f;
    }
}

