/*
 * Decompiled with CFR 0.152.
 */
package com.ladybug.engine.components;

import com.badlogic.gdx.math.Rectangle;
import com.ladybug.engine.components.Collider;
import com.ladybug.engine.gameobject.GameObject;

public class BoxCollider
extends Collider {
    protected Rectangle m_rect;
    Rectangle rectTemp;
    Rectangle rectTempOther;

    public BoxCollider() {
        this.m_rect = new Rectangle();
        this.m_collType = Collider.Type.BOX;
    }

    public BoxCollider(float w, float h) {
        this.m_rect = new Rectangle(0.0f, 0.0f, w, h);
        this.m_collType = Collider.Type.BOX;
    }

    public BoxCollider(Rectangle rect) {
        this.m_rect = rect;
        this.m_collType = Collider.Type.BOX;
    }

    @Override
    public void scale(float w, float h) {
        this.m_rect.width *= w;
        this.m_rect.height *= h;
    }

    @Override
    protected boolean collide(BoxCollider coll) {
        return this.getBounds().overlaps(coll.getBounds());
    }

    public Rectangle getRectangle() {
        return this.m_rect;
    }

    protected Rectangle getBounds() {
        return new Rectangle(this.m_object.getPosition().x + this.m_rect.x, this.m_object.getPosition().y + this.m_rect.y, this.m_rect.width, this.m_rect.height);
    }

    @Override
    public float top() {
        return this.m_object.getPosition().y + this.m_rect.y;
    }

    @Override
    public float bottom() {
        return this.m_object.getPosition().y + this.m_rect.y + this.m_rect.height;
    }

    @Override
    public float right() {
        return this.m_object.getPosition().x + this.m_rect.x + this.m_rect.width;
    }

    @Override
    public float left() {
        return this.m_object.getPosition().x + this.m_rect.x;
    }

    public void setRectangle(Rectangle rect) {
        this.m_rect = rect;
    }

    @Override
    public void setObject(GameObject go) {
        super.setObject(go);
    }
}

