/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.tablelayout;

import com.esotericsoftware.tablelayout.Cell;
import com.esotericsoftware.tablelayout.Toolkit;
import com.esotericsoftware.tablelayout.Value;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseTableLayout<C, T extends C, L extends BaseTableLayout, K extends Toolkit<C, T, L>> {
    public static final int CENTER = 1;
    public static final int TOP = 2;
    public static final int BOTTOM = 4;
    public static final int LEFT = 8;
    public static final int RIGHT = 16;
    K toolkit;
    T table;
    private int columns;
    private int rows;
    private final ArrayList<Cell> cells = new ArrayList(4);
    private final Cell cellDefaults = Cell.defaults(this);
    private final ArrayList<Cell> columnDefaults = new ArrayList(2);
    private Cell rowDefaults;
    private boolean sizeInvalid = true;
    private float[] columnMinWidth;
    private float[] rowMinHeight;
    private float[] columnPrefWidth;
    private float[] rowPrefHeight;
    private float tableMinWidth;
    private float tableMinHeight;
    private float tablePrefWidth;
    private float tablePrefHeight;
    private float[] columnWidth;
    private float[] rowHeight;
    private float[] expandWidth;
    private float[] expandHeight;
    private float[] columnWeightedWidth;
    private float[] rowWeightedHeight;
    Value padTop;
    Value padLeft;
    Value padBottom;
    Value padRight;
    int align = 1;
    Debug debug = Debug.none;

    public BaseTableLayout(K toolkit) {
        this.toolkit = toolkit;
    }

    public void invalidate() {
        this.sizeInvalid = true;
    }

    public abstract void invalidateHierarchy();

    public Cell<C> add(C widget) {
        Cell cell = new Cell(this);
        cell.widget = widget;
        if (this.cells.size() > 0) {
            Cell lastCell = this.cells.get(this.cells.size() - 1);
            if (!lastCell.endRow) {
                cell.column = lastCell.column + lastCell.colspan;
                cell.row = lastCell.row;
            } else {
                cell.row = lastCell.row + 1;
            }
            if (cell.row > 0) {
                block0: for (int i = this.cells.size() - 1; i >= 0; --i) {
                    int column;
                    Cell other = this.cells.get(i);
                    int nn = column + other.colspan;
                    for (column = other.column; column < nn; ++column) {
                        if (column != cell.column) continue;
                        cell.cellAboveIndex = i;
                        break block0;
                    }
                }
            }
        }
        this.cells.add(cell);
        if (cell.column < this.columnDefaults.size()) {
            Cell columnDefaults = this.columnDefaults.get(cell.column);
            cell.set(columnDefaults != null ? columnDefaults : this.cellDefaults);
        } else {
            cell.set(this.cellDefaults);
        }
        cell.merge(this.rowDefaults);
        if (widget != null) {
            ((Toolkit)this.toolkit).addChild(this.table, widget);
        }
        return cell;
    }

    public Cell row() {
        if (this.cells.size() > 0) {
            this.endRow();
        }
        this.rowDefaults = new Cell(this);
        return this.rowDefaults;
    }

    private void endRow() {
        int rowColumns = 0;
        for (int i = this.cells.size() - 1; i >= 0; --i) {
            Cell cell = this.cells.get(i);
            if (cell.endRow) break;
            rowColumns += cell.colspan.intValue();
        }
        this.columns = Math.max(this.columns, rowColumns);
        ++this.rows;
        this.cells.get((int)(this.cells.size() - 1)).endRow = true;
        this.invalidate();
    }

    public Cell columnDefaults(int column) {
        Cell cell;
        Cell cell2 = cell = this.columnDefaults.size() > column ? this.columnDefaults.get(column) : null;
        if (cell == null) {
            cell = new Cell(this);
            cell.set(this.cellDefaults);
            if (column >= this.columnDefaults.size()) {
                for (int i = this.columnDefaults.size(); i < column; ++i) {
                    this.columnDefaults.add(null);
                }
                this.columnDefaults.add(cell);
            } else {
                this.columnDefaults.set(column, cell);
            }
        }
        return cell;
    }

    public void reset() {
        this.clear();
        this.padTop = null;
        this.padLeft = null;
        this.padBottom = null;
        this.padRight = null;
        this.align = 1;
        if (this.debug != Debug.none) {
            ((Toolkit)this.toolkit).clearDebugRectangles((BaseTableLayout)this);
        }
        this.debug = Debug.none;
        this.cellDefaults.set(Cell.defaults(this));
        this.columnDefaults.clear();
        this.rowDefaults = null;
    }

    public void clear() {
        for (int i = this.cells.size() - 1; i >= 0; --i) {
            Object widget = this.cells.get((int)i).widget;
            if (widget == null) continue;
            ((Toolkit)this.toolkit).removeChild(this.table, widget);
        }
        this.cells.clear();
        this.rows = 0;
        this.columns = 0;
        this.invalidate();
    }

    public Cell getCell(C widget) {
        int n = this.cells.size();
        for (int i = 0; i < n; ++i) {
            Cell c = this.cells.get(i);
            if (c.widget != widget) continue;
            return c;
        }
        return null;
    }

    public List<Cell> getCells() {
        return this.cells;
    }

    public void setToolkit(K toolkit) {
        this.toolkit = toolkit;
    }

    public T getTable() {
        return this.table;
    }

    public void setTable(T table) {
        this.table = table;
    }

    public float getMinWidth() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.tableMinWidth;
    }

    public float getMinHeight() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.tableMinHeight;
    }

    public float getPrefWidth() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.tablePrefWidth;
    }

    public float getPrefHeight() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.tablePrefHeight;
    }

    public Cell defaults() {
        return this.cellDefaults;
    }

    public L pad(Value pad) {
        this.padTop = pad;
        this.padLeft = pad;
        this.padBottom = pad;
        this.padRight = pad;
        this.sizeInvalid = true;
        return (L)this;
    }

    public L pad(Value top, Value left, Value bottom, Value right) {
        this.padTop = top;
        this.padLeft = left;
        this.padBottom = bottom;
        this.padRight = right;
        this.sizeInvalid = true;
        return (L)this;
    }

    public L padTop(Value padTop) {
        this.padTop = padTop;
        this.sizeInvalid = true;
        return (L)this;
    }

    public L padLeft(Value padLeft) {
        this.padLeft = padLeft;
        this.sizeInvalid = true;
        return (L)this;
    }

    public L padBottom(Value padBottom) {
        this.padBottom = padBottom;
        this.sizeInvalid = true;
        return (L)this;
    }

    public L padRight(Value padRight) {
        this.padRight = padRight;
        this.sizeInvalid = true;
        return (L)this;
    }

    public L pad(float pad) {
        this.padTop = new Value.FixedValue(pad);
        this.padLeft = new Value.FixedValue(pad);
        this.padBottom = new Value.FixedValue(pad);
        this.padRight = new Value.FixedValue(pad);
        this.sizeInvalid = true;
        return (L)this;
    }

    public L pad(float top, float left, float bottom, float right) {
        this.padTop = new Value.FixedValue(top);
        this.padLeft = new Value.FixedValue(left);
        this.padBottom = new Value.FixedValue(bottom);
        this.padRight = new Value.FixedValue(right);
        this.sizeInvalid = true;
        return (L)this;
    }

    public L padTop(float padTop) {
        this.padTop = new Value.FixedValue(padTop);
        this.sizeInvalid = true;
        return (L)this;
    }

    public L padLeft(float padLeft) {
        this.padLeft = new Value.FixedValue(padLeft);
        this.sizeInvalid = true;
        return (L)this;
    }

    public L padBottom(float padBottom) {
        this.padBottom = new Value.FixedValue(padBottom);
        this.sizeInvalid = true;
        return (L)this;
    }

    public L padRight(float padRight) {
        this.padRight = new Value.FixedValue(padRight);
        this.sizeInvalid = true;
        return (L)this;
    }

    public L align(int align) {
        this.align = align;
        return (L)this;
    }

    public L center() {
        this.align = 1;
        return (L)this;
    }

    public L top() {
        this.align |= 2;
        this.align &= 0xFFFFFFFB;
        return (L)this;
    }

    public L left() {
        this.align |= 8;
        this.align &= 0xFFFFFFEF;
        return (L)this;
    }

    public L bottom() {
        this.align |= 4;
        this.align &= 0xFFFFFFFD;
        return (L)this;
    }

    public L right() {
        this.align |= 0x10;
        this.align &= 0xFFFFFFF7;
        return (L)this;
    }

    public L debug() {
        this.debug = Debug.all;
        this.invalidate();
        return (L)this;
    }

    public L debugTable() {
        this.debug = Debug.table;
        this.invalidate();
        return (L)this;
    }

    public L debugCell() {
        this.debug = Debug.cell;
        this.invalidate();
        return (L)this;
    }

    public L debugWidget() {
        this.debug = Debug.widget;
        this.invalidate();
        return (L)this;
    }

    public L debug(Debug debug) {
        this.debug = debug;
        if (debug == Debug.none) {
            ((Toolkit)this.toolkit).clearDebugRectangles((BaseTableLayout)this);
        } else {
            this.invalidate();
        }
        return (L)this;
    }

    public Debug getDebug() {
        return this.debug;
    }

    public Value getPadTopValue() {
        return this.padTop;
    }

    public float getPadTop() {
        return this.padTop == null ? 0.0f : this.padTop.height(this);
    }

    public Value getPadLeftValue() {
        return this.padLeft;
    }

    public float getPadLeft() {
        return this.padLeft == null ? 0.0f : this.padLeft.width(this);
    }

    public Value getPadBottomValue() {
        return this.padBottom;
    }

    public float getPadBottom() {
        return this.padBottom == null ? 0.0f : this.padBottom.height(this);
    }

    public Value getPadRightValue() {
        return this.padRight;
    }

    public float getPadRight() {
        return this.padRight == null ? 0.0f : this.padRight.width(this);
    }

    public int getAlign() {
        return this.align;
    }

    public int getRow(float y) {
        int i;
        int row = 0;
        y += this.h(this.padTop);
        int n = this.cells.size();
        if (n == 0) {
            return -1;
        }
        for (i = 0; i < n && !this.cells.get(i).isEndRow(); ++i) {
        }
        while (i < n) {
            Cell c;
            if ((c = this.cells.get(i++)).getIgnore()) continue;
            if (c.widgetY + c.computedPadTop > y) break;
            if (!c.endRow) continue;
            ++row;
        }
        return this.rows - row;
    }

    private float[] ensureSize(float[] array, int size) {
        if (array == null || array.length < size) {
            return new float[size];
        }
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            array[i] = 0.0f;
        }
        return array;
    }

    private float w(Value value) {
        return value == null ? 0.0f : value.width(this.table);
    }

    private float h(Value value) {
        return value == null ? 0.0f : value.height(this.table);
    }

    private float w(Value value, Cell cell) {
        return value == null ? 0.0f : value.width(cell);
    }

    private float h(Value value, Cell cell) {
        return value == null ? 0.0f : value.height(cell);
    }

    private void computeSize() {
        float vpadding;
        float hpadding;
        int i;
        Cell c;
        int i2;
        this.sizeInvalid = false;
        K toolkit = this.toolkit;
        ArrayList<Cell> cells = this.cells;
        if (cells.size() > 0 && !cells.get((int)(cells.size() - 1)).endRow) {
            this.endRow();
        }
        this.columnMinWidth = this.ensureSize(this.columnMinWidth, this.columns);
        this.rowMinHeight = this.ensureSize(this.rowMinHeight, this.rows);
        this.columnPrefWidth = this.ensureSize(this.columnPrefWidth, this.columns);
        this.rowPrefHeight = this.ensureSize(this.rowPrefHeight, this.rows);
        this.columnWidth = this.ensureSize(this.columnWidth, this.columns);
        this.rowHeight = this.ensureSize(this.rowHeight, this.rows);
        this.expandWidth = this.ensureSize(this.expandWidth, this.columns);
        this.expandHeight = this.ensureSize(this.expandHeight, this.rows);
        float spaceRightLast = 0.0f;
        int n = cells.size();
        for (i2 = 0; i2 < n; ++i2) {
            c = cells.get(i2);
            if (c.ignore.booleanValue()) continue;
            if (c.expandY != 0 && this.expandHeight[c.row] == 0.0f) {
                this.expandHeight[c.row] = c.expandY.intValue();
            }
            if (c.colspan == 1 && c.expandX != 0 && this.expandWidth[c.column] == 0.0f) {
                this.expandWidth[c.column] = c.expandX.intValue();
            }
            c.computedPadLeft = this.w(c.padLeft, c) + (c.column == 0 ? 0.0f : Math.max(0.0f, this.w(c.spaceLeft, c) - spaceRightLast));
            c.computedPadTop = this.h(c.padTop, c);
            if (c.cellAboveIndex != -1) {
                Cell above = cells.get(c.cellAboveIndex);
                c.computedPadTop += Math.max(0.0f, this.h(c.spaceTop, c) - this.h(above.spaceBottom, above));
            }
            float spaceRight = this.w(c.spaceRight, c);
            c.computedPadRight = this.w(c.padRight, c) + (c.column + c.colspan == this.columns ? 0.0f : spaceRight);
            c.computedPadBottom = this.h(c.padBottom, c) + (c.row == this.rows - 1 ? 0.0f : this.h(c.spaceBottom, c));
            spaceRightLast = spaceRight;
            float prefWidth = this.w(c.prefWidth, c);
            float prefHeight = this.h(c.prefHeight, c);
            float minWidth = this.w(c.minWidth, c);
            float minHeight = this.h(c.minHeight, c);
            float maxWidth = this.w(c.maxWidth, c);
            float maxHeight = this.h(c.maxHeight, c);
            if (prefWidth < minWidth) {
                prefWidth = minWidth;
            }
            if (prefHeight < minHeight) {
                prefHeight = minHeight;
            }
            if (maxWidth > 0.0f && prefWidth > maxWidth) {
                prefWidth = maxWidth;
            }
            if (maxHeight > 0.0f && prefHeight > maxHeight) {
                prefHeight = maxHeight;
            }
            if (c.colspan == 1) {
                float hpadding2 = c.computedPadLeft + c.computedPadRight;
                this.columnPrefWidth[c.column] = Math.max(this.columnPrefWidth[c.column], prefWidth + hpadding2);
                this.columnMinWidth[c.column] = Math.max(this.columnMinWidth[c.column], minWidth + hpadding2);
            }
            float vpadding2 = c.computedPadTop + c.computedPadBottom;
            this.rowPrefHeight[c.row] = Math.max(this.rowPrefHeight[c.row], prefHeight + vpadding2);
            this.rowMinHeight[c.row] = Math.max(this.rowMinHeight[c.row], minHeight + vpadding2);
        }
        n = cells.size();
        block1: for (i2 = 0; i2 < n; ++i2) {
            int column;
            c = cells.get(i2);
            if (c.ignore.booleanValue() || c.expandX == 0) continue;
            int nn = column + c.colspan;
            for (column = c.column; column < nn; ++column) {
                if (this.expandWidth[column] != 0.0f) continue block1;
            }
            nn = column + c.colspan;
            for (column = c.column; column < nn; ++column) {
                this.expandWidth[column] = c.expandX.intValue();
            }
        }
        n = cells.size();
        for (i2 = 0; i2 < n; ++i2) {
            int column;
            int column2;
            c = cells.get(i2);
            if (c.ignore.booleanValue() || c.colspan == 1) continue;
            float minWidth = this.w(c.minWidth, c);
            float prefWidth = this.w(c.prefWidth, c);
            float maxWidth = this.w(c.maxWidth, c);
            if (prefWidth < minWidth) {
                prefWidth = minWidth;
            }
            if (maxWidth > 0.0f && prefWidth > maxWidth) {
                prefWidth = maxWidth;
            }
            float spannedMinWidth = 0.0f;
            float spannedPrefWidth = 0.0f;
            int nn = column2 + c.colspan;
            for (column2 = c.column; column2 < nn; ++column2) {
                spannedMinWidth += this.columnMinWidth[column2];
                spannedPrefWidth += this.columnPrefWidth[column2];
            }
            float totalExpandWidth = 0.0f;
            int nn2 = column + c.colspan;
            for (column = c.column; column < nn2; ++column) {
                totalExpandWidth += this.expandWidth[column];
            }
            float extraMinWidth = Math.max(0.0f, minWidth - spannedMinWidth);
            float extraPrefWidth = Math.max(0.0f, prefWidth - spannedPrefWidth);
            int column3 = c.column;
            int nn3 = column3 + c.colspan;
            while (column3 < nn3) {
                float ratio = totalExpandWidth == 0.0f ? 1.0f / (float)c.colspan.intValue() : this.expandWidth[column3] / totalExpandWidth;
                int n2 = column3;
                this.columnMinWidth[n2] = this.columnMinWidth[n2] + extraMinWidth * ratio;
                int n3 = column3++;
                this.columnPrefWidth[n3] = this.columnPrefWidth[n3] + extraPrefWidth * ratio;
            }
        }
        float uniformMinWidth = 0.0f;
        float uniformMinHeight = 0.0f;
        float uniformPrefWidth = 0.0f;
        float uniformPrefHeight = 0.0f;
        int n4 = cells.size();
        for (i = 0; i < n4; ++i) {
            Cell c2 = cells.get(i);
            if (c2.ignore.booleanValue()) continue;
            if (c2.uniformX == Boolean.TRUE && c2.colspan == 1) {
                hpadding = c2.computedPadLeft + c2.computedPadRight;
                uniformMinWidth = Math.max(uniformMinWidth, this.columnMinWidth[c2.column] - hpadding);
                uniformPrefWidth = Math.max(uniformPrefWidth, this.columnPrefWidth[c2.column] - hpadding);
            }
            if (c2.uniformY != Boolean.TRUE) continue;
            vpadding = c2.computedPadTop + c2.computedPadBottom;
            uniformMinHeight = Math.max(uniformMinHeight, this.rowMinHeight[c2.row] - vpadding);
            uniformPrefHeight = Math.max(uniformPrefHeight, this.rowPrefHeight[c2.row] - vpadding);
        }
        if (uniformPrefWidth > 0.0f || uniformPrefHeight > 0.0f) {
            n4 = cells.size();
            for (i = 0; i < n4; ++i) {
                Cell c3 = cells.get(i);
                if (c3.ignore.booleanValue()) continue;
                if (uniformPrefWidth > 0.0f && c3.uniformX == Boolean.TRUE && c3.colspan == 1) {
                    hpadding = c3.computedPadLeft + c3.computedPadRight;
                    this.columnMinWidth[c3.column] = uniformMinWidth + hpadding;
                    this.columnPrefWidth[c3.column] = uniformPrefWidth + hpadding;
                }
                if (!(uniformPrefHeight > 0.0f) || c3.uniformY != Boolean.TRUE) continue;
                vpadding = c3.computedPadTop + c3.computedPadBottom;
                this.rowMinHeight[c3.row] = uniformMinHeight + vpadding;
                this.rowPrefHeight[c3.row] = uniformPrefHeight + vpadding;
            }
        }
        this.tableMinWidth = 0.0f;
        this.tableMinHeight = 0.0f;
        this.tablePrefWidth = 0.0f;
        this.tablePrefHeight = 0.0f;
        for (i = 0; i < this.columns; ++i) {
            this.tableMinWidth += this.columnMinWidth[i];
            this.tablePrefWidth += this.columnPrefWidth[i];
        }
        for (i = 0; i < this.rows; ++i) {
            this.tableMinHeight += this.rowMinHeight[i];
            this.tablePrefHeight += Math.max(this.rowMinHeight[i], this.rowPrefHeight[i]);
        }
        float hpadding3 = this.w(this.padLeft) + this.w(this.padRight);
        float vpadding3 = this.h(this.padTop) + this.h(this.padBottom);
        this.tableMinWidth += hpadding3;
        this.tableMinHeight += vpadding3;
        this.tablePrefWidth = Math.max(this.tablePrefWidth + hpadding3, this.tableMinWidth);
        this.tablePrefHeight = Math.max(this.tablePrefHeight + vpadding3, this.tableMinHeight);
    }

    public void layout(float layoutX, float layoutY, float layoutWidth, float layoutHeight) {
        int nn;
        float spannedCellWidth;
        int i;
        int i2;
        float amount;
        float[] rowWeightedHeight;
        float[] columnWeightedWidth;
        int i3;
        K toolkit = this.toolkit;
        ArrayList<Cell> cells = this.cells;
        if (this.sizeInvalid) {
            this.computeSize();
        }
        float hpadding = this.w(this.padLeft) + this.w(this.padRight);
        float vpadding = this.h(this.padTop) + this.h(this.padBottom);
        float totalMinWidth = 0.0f;
        float totalMinHeight = 0.0f;
        float totalExpandWidth = 0.0f;
        float totalExpandHeight = 0.0f;
        for (i3 = 0; i3 < this.columns; ++i3) {
            totalMinWidth += this.columnMinWidth[i3];
            totalExpandWidth += this.expandWidth[i3];
        }
        for (i3 = 0; i3 < this.rows; ++i3) {
            totalMinHeight += this.rowMinHeight[i3];
            totalExpandHeight += this.expandHeight[i3];
        }
        float totalGrowWidth = this.tablePrefWidth - totalMinWidth;
        if (totalGrowWidth == 0.0f) {
            columnWeightedWidth = this.columnMinWidth;
        } else {
            float extraWidth = Math.min(totalGrowWidth, Math.max(0.0f, layoutWidth - totalMinWidth));
            this.columnWeightedWidth = this.ensureSize(this.columnWeightedWidth, this.columns);
            columnWeightedWidth = this.columnWeightedWidth;
            for (int i4 = 0; i4 < this.columns; ++i4) {
                float growWidth = this.columnPrefWidth[i4] - this.columnMinWidth[i4];
                float growRatio = growWidth / totalGrowWidth;
                columnWeightedWidth[i4] = this.columnMinWidth[i4] + extraWidth * growRatio;
            }
        }
        float totalGrowHeight = this.tablePrefHeight - totalMinHeight;
        if (totalGrowHeight == 0.0f) {
            rowWeightedHeight = this.rowMinHeight;
        } else {
            this.rowWeightedHeight = this.ensureSize(this.rowWeightedHeight, this.rows);
            rowWeightedHeight = this.rowWeightedHeight;
            float extraHeight = Math.min(totalGrowHeight, Math.max(0.0f, layoutHeight - totalMinHeight));
            for (int i5 = 0; i5 < this.rows; ++i5) {
                float growHeight = this.rowPrefHeight[i5] - this.rowMinHeight[i5];
                float growRatio = growHeight / totalGrowHeight;
                rowWeightedHeight[i5] = this.rowMinHeight[i5] + extraHeight * growRatio;
            }
        }
        int n = cells.size();
        for (int i6 = 0; i6 < n; ++i6) {
            int column;
            Cell c = cells.get(i6);
            if (c.ignore.booleanValue()) continue;
            float spannedWeightedWidth = 0.0f;
            int nn2 = column + c.colspan;
            for (column = c.column; column < nn2; ++column) {
                spannedWeightedWidth += columnWeightedWidth[column];
            }
            float weightedHeight = rowWeightedHeight[c.row];
            float prefWidth = this.w(c.prefWidth, c);
            float prefHeight = this.h(c.prefHeight, c);
            float minWidth = this.w(c.minWidth, c);
            float minHeight = this.h(c.minHeight, c);
            float maxWidth = this.w(c.maxWidth, c);
            float maxHeight = this.h(c.maxHeight, c);
            if (prefWidth < minWidth) {
                prefWidth = minWidth;
            }
            if (prefHeight < minHeight) {
                prefHeight = minHeight;
            }
            if (maxWidth > 0.0f && prefWidth > maxWidth) {
                prefWidth = maxWidth;
            }
            if (maxHeight > 0.0f && prefHeight > maxHeight) {
                prefHeight = maxHeight;
            }
            c.widgetWidth = Math.min(spannedWeightedWidth - c.computedPadLeft - c.computedPadRight, prefWidth);
            c.widgetHeight = Math.min(weightedHeight - c.computedPadTop - c.computedPadBottom, prefHeight);
            if (c.colspan == 1) {
                this.columnWidth[c.column] = Math.max(this.columnWidth[c.column], spannedWeightedWidth);
            }
            this.rowHeight[c.row] = Math.max(this.rowHeight[c.row], weightedHeight);
        }
        if (totalExpandWidth > 0.0f) {
            float extra = layoutWidth - hpadding;
            for (int i7 = 0; i7 < this.columns; ++i7) {
                extra -= this.columnWidth[i7];
            }
            float used = 0.0f;
            int lastIndex = 0;
            for (int i8 = 0; i8 < this.columns; ++i8) {
                if (this.expandWidth[i8] == 0.0f) continue;
                amount = extra * this.expandWidth[i8] / totalExpandWidth;
                int n2 = i8;
                this.columnWidth[n2] = this.columnWidth[n2] + amount;
                used += amount;
                lastIndex = i8;
            }
            int n3 = lastIndex;
            this.columnWidth[n3] = this.columnWidth[n3] + (extra - used);
        }
        if (totalExpandHeight > 0.0f) {
            float extra = layoutHeight - vpadding;
            for (int i9 = 0; i9 < this.rows; ++i9) {
                extra -= this.rowHeight[i9];
            }
            float used = 0.0f;
            int lastIndex = 0;
            for (int i10 = 0; i10 < this.rows; ++i10) {
                if (this.expandHeight[i10] == 0.0f) continue;
                amount = extra * this.expandHeight[i10] / totalExpandHeight;
                int n4 = i10;
                this.rowHeight[n4] = this.rowHeight[n4] + amount;
                used += amount;
                lastIndex = i10;
            }
            int n5 = lastIndex;
            this.rowHeight[n5] = this.rowHeight[n5] + (extra - used);
        }
        n = cells.size();
        for (int i11 = 0; i11 < n; ++i11) {
            int column;
            Cell c = cells.get(i11);
            if (c.ignore.booleanValue() || c.colspan == 1) continue;
            float extraWidth = 0.0f;
            int nn3 = column + c.colspan;
            for (column = c.column; column < nn3; ++column) {
                extraWidth += columnWeightedWidth[column] - this.columnWidth[column];
            }
            extraWidth -= Math.max(0.0f, c.computedPadLeft + c.computedPadRight);
            if (!((extraWidth /= (float)c.colspan.intValue()) > 0.0f)) continue;
            column = c.column;
            nn3 = column + c.colspan;
            while (column < nn3) {
                int n6 = column++;
                this.columnWidth[n6] = this.columnWidth[n6] + extraWidth;
            }
        }
        float tableWidth = hpadding;
        float tableHeight = vpadding;
        for (i2 = 0; i2 < this.columns; ++i2) {
            tableWidth += this.columnWidth[i2];
        }
        for (i2 = 0; i2 < this.rows; ++i2) {
            tableHeight += this.rowHeight[i2];
        }
        float x = layoutX + this.w(this.padLeft);
        if ((this.align & 0x10) != 0) {
            x += layoutWidth - tableWidth;
        } else if ((this.align & 8) == 0) {
            x += (layoutWidth - tableWidth) / 2.0f;
        }
        float y = layoutY + this.w(this.padTop);
        if ((this.align & 4) != 0) {
            y += layoutHeight - tableHeight;
        } else if ((this.align & 2) == 0) {
            y += (layoutHeight - tableHeight) / 2.0f;
        }
        float currentX = x;
        float currentY = y;
        int n7 = cells.size();
        for (i = 0; i < n7; ++i) {
            int column;
            Cell c = cells.get(i);
            if (c.ignore.booleanValue()) continue;
            spannedCellWidth = 0.0f;
            nn = column + c.colspan;
            for (column = c.column; column < nn; ++column) {
                spannedCellWidth += this.columnWidth[column];
            }
            spannedCellWidth -= c.computedPadLeft + c.computedPadRight;
            currentX += c.computedPadLeft;
            if (c.fillX.floatValue() > 0.0f) {
                c.widgetWidth = spannedCellWidth * c.fillX.floatValue();
                float maxWidth = this.w(c.maxWidth, c);
                if (maxWidth > 0.0f) {
                    c.widgetWidth = Math.min(c.widgetWidth, maxWidth);
                }
            }
            if (c.fillY.floatValue() > 0.0f) {
                c.widgetHeight = this.rowHeight[c.row] * c.fillY.floatValue() - c.computedPadTop - c.computedPadBottom;
                float maxHeight = this.h(c.maxHeight, c);
                if (maxHeight > 0.0f) {
                    c.widgetHeight = Math.min(c.widgetHeight, maxHeight);
                }
            }
            c.widgetX = (c.align & 8) != 0 ? currentX : ((c.align & 0x10) != 0 ? currentX + spannedCellWidth - c.widgetWidth : currentX + (spannedCellWidth - c.widgetWidth) / 2.0f);
            c.widgetY = (c.align & 2) != 0 ? currentY + c.computedPadTop : ((c.align & 4) != 0 ? currentY + this.rowHeight[c.row] - c.widgetHeight - c.computedPadBottom : currentY + (this.rowHeight[c.row] - c.widgetHeight + c.computedPadTop - c.computedPadBottom) / 2.0f);
            if (c.endRow) {
                currentX = x;
                currentY += this.rowHeight[c.row];
                continue;
            }
            currentX += spannedCellWidth + c.computedPadRight;
        }
        if (this.debug == Debug.none) {
            return;
        }
        ((Toolkit)toolkit).clearDebugRectangles((BaseTableLayout)this);
        currentX = x;
        currentY = y;
        if (this.debug == Debug.table || this.debug == Debug.all) {
            ((Toolkit)toolkit).addDebugRectangle((BaseTableLayout)this, Debug.table, layoutX, layoutY, layoutWidth, layoutHeight);
            ((Toolkit)toolkit).addDebugRectangle((BaseTableLayout)this, Debug.table, x, y, tableWidth - hpadding, tableHeight - vpadding);
        }
        n7 = cells.size();
        for (i = 0; i < n7; ++i) {
            int column;
            Cell c = cells.get(i);
            if (c.ignore.booleanValue()) continue;
            if (this.debug == Debug.widget || this.debug == Debug.all) {
                ((Toolkit)toolkit).addDebugRectangle((BaseTableLayout)this, Debug.widget, c.widgetX, c.widgetY, c.widgetWidth, c.widgetHeight);
            }
            spannedCellWidth = 0.0f;
            nn = column + c.colspan;
            for (column = c.column; column < nn; ++column) {
                spannedCellWidth += this.columnWidth[column];
            }
            spannedCellWidth -= c.computedPadLeft + c.computedPadRight;
            currentX += c.computedPadLeft;
            if (this.debug == Debug.cell || this.debug == Debug.all) {
                ((Toolkit)toolkit).addDebugRectangle((BaseTableLayout)this, Debug.cell, currentX, currentY + c.computedPadTop, spannedCellWidth, this.rowHeight[c.row] - c.computedPadTop - c.computedPadBottom);
            }
            if (c.endRow) {
                currentX = x;
                currentY += this.rowHeight[c.row];
                continue;
            }
            currentX += spannedCellWidth + c.computedPadRight;
        }
    }

    public static enum Debug {
        none,
        all,
        table,
        cell,
        widget;

    }
}

