/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.ObjectMap;

public class Dialog
extends Window {
    public static float fadeDuration = 0.4f;
    Table contentTable;
    Table buttonTable;
    private Skin skin;
    ObjectMap<Actor, Object> values = new ObjectMap();

    public Dialog(String title, Skin skin) {
        super(title, skin.get(Window.WindowStyle.class));
        this.skin = skin;
        this.initialize();
    }

    public Dialog(String title, Skin skin, String windowStyleName) {
        super(title, skin.get(windowStyleName, Window.WindowStyle.class));
        this.skin = skin;
        this.initialize();
    }

    public Dialog(String title, Window.WindowStyle windowStyle) {
        super(title, windowStyle);
        this.initialize();
    }

    private void initialize() {
        this.setModal(true);
        this.defaults().space(6.0f);
        this.contentTable = new Table(this.skin);
        this.add(this.contentTable).expand();
        this.row();
        this.buttonTable = new Table(this.skin);
        this.add(this.buttonTable);
        this.contentTable.defaults().space(6.0f);
        this.buttonTable.defaults().space(6.0f);
        this.buttonTable.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                while (actor.getParent() != Dialog.this.buttonTable) {
                    actor = actor.getParent();
                }
                Dialog.this.result(Dialog.this.values.get(actor));
                Dialog.this.hide();
            }
        });
    }

    @Override
    public void draw(SpriteBatch batch, float parentAlpha) {
        Stage stage = this.getStage();
        if (stage.getKeyboardFocus() == null) {
            stage.setKeyboardFocus(this);
        }
        super.draw(batch, parentAlpha);
    }

    public Table getContentTable() {
        return this.contentTable;
    }

    public Table getButtonTable() {
        return this.buttonTable;
    }

    public Dialog text(String text) {
        if (this.skin == null) {
            throw new IllegalStateException("This method may only be used if the dialog was constructed with a Skin.");
        }
        return this.text(text, this.skin.get(Label.LabelStyle.class));
    }

    public Dialog text(String text, Label.LabelStyle labelStyle) {
        return this.text(new Label((CharSequence)text, labelStyle));
    }

    public Dialog text(Label label) {
        this.contentTable.add(label);
        return this;
    }

    public Dialog button(String text) {
        return this.button(text, null);
    }

    public Dialog button(String text, Object object) {
        if (this.skin == null) {
            throw new IllegalStateException("This method may only be used if the dialog was constructed with a Skin.");
        }
        return this.button(text, object, this.skin.get(TextButton.TextButtonStyle.class));
    }

    public Dialog button(String text, Object object, TextButton.TextButtonStyle buttonStyle) {
        return this.button(new TextButton(text, buttonStyle), object);
    }

    public Dialog button(Button button) {
        return this.button(button, null);
    }

    public Dialog button(Button button, Object object) {
        this.buttonTable.add(button);
        this.setObject(button, object);
        return this;
    }

    public Dialog show(Stage stage) {
        stage.setKeyboardFocus(this);
        stage.setScrollFocus(this);
        this.pack();
        this.setPosition(Math.round((stage.getWidth() - this.getWidth()) / 2.0f), Math.round((stage.getHeight() - this.getHeight()) / 2.0f));
        stage.addActor(this);
        if (fadeDuration > 0.0f) {
            this.getColor().a = 0.0f;
            this.addAction(Actions.fadeIn(fadeDuration, Interpolation.fade));
        }
        return this;
    }

    public void hide() {
        this.addAction(Actions.sequence((Action)Actions.fadeOut(fadeDuration, Interpolation.fade), (Action)Actions.removeActor()));
    }

    public void setObject(Actor actor, Object object) {
        this.values.put(actor, object);
    }

    public Dialog key(final int keycode, final Object object) {
        this.addListener(new InputListener(){

            @Override
            public boolean keyDown(InputEvent event, int keycode2) {
                if (keycode == keycode2) {
                    Dialog.this.result(object);
                    Dialog.this.hide();
                }
                return false;
            }
        });
        return this;
    }

    protected void result(Object object) {
    }
}

